
<!--
  Support for Bibles, Bible references, citations, commentary in Voyager.
  From the ThML DTD, v1.0.  File: bible.mod

  Author: Harry Plantinga (hplantin@calvin.edu), January 1, 2000. 
  This file may be copied according to the terms of the Artistic License.

  version 1.01, 2002-09-04: allow osisRef and osisID attributes
-->

 <!--=========================  Bibles  =============================-->
 <!--=========== references, citations, commentary ==================-->

 <!ENTITY % scripturePassage "CDATA"> <!-- e.g. Rom. 8:28-30, 9.10-1, Rev2-->
 <!ENTITY % scriptureParsed  "CDATA"> <!-- version|bk|fch|fv|tch|tv -->
 <!ENTITY % osisIDType       "CDATA"> <!-- Matt.1.1, e.g. -->
 <!ENTITY % osisRefType	     "CDATA"> <!-- Bible:Matt.1.1-Matt.1.3, e.g. -->
 <!ENTITY % scriptureVersion "(NIV | KJV | NKJV | RSV | NRSV | ASV | 
    NEB | VUL | LXX)"> 
 <!ENTITY % scripComType     "(Commentary | Hymn | Sermon | Outline | 
    Meditation | Treatise | Study | Poem | Citation)">

 <!ELEMENT scripture (#PCDATA | %block; | %inline; | %misc;)*> 
 <!ATTLIST scripture %attrs;
   version %scriptureVersion;  #IMPLIED
   passage %scripturePassage;  #IMPLIED
   parsed  %scriptureParsed;   #IMPLIED
   osisRef %osisRefType;       #IMPLIED
   osisID  %osisIDType;        #IMPLIED>

 <!ELEMENT scripContext EMPTY>
 <!ATTLIST scripContext %attrs;
   version %scriptureVersion;  #IMPLIED
   passage %scripturePassage;  #IMPLIED
   parsed  %scriptureParsed;   #IMPLIED>

 <!ELEMENT scripRef %Inline;>
 <!ATTLIST scripRef %attrs;
   version %scriptureVersion;  #IMPLIED
   passage %scripturePassage;  #IMPLIED
   parsed  %scriptureParsed;   #IMPLIED
   target  %URI;               #IMPLIED
   osisRef %osisRefType;       #IMPLIED>
   
 <!ELEMENT scripCom EMPTY>
 <!ATTLIST scripCom %attrs;
   type    %scripComType;      "Citation"
   version %scriptureVersion;  #IMPLIED
   passage %scripturePassage;  #IMPLIED
   parsed  %scriptureParsed;   #IMPLIED
   target  %URI;               #IMPLIED
   osisRef %osisRefType;       #IMPLIED>
   

 <!ENTITY % misc.bible "| scripContext | scripRef | scripCom | scripture">

